/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.cme_entitytracker.core;

import io.github.zekerzhayard.cme_entitytracker.core.RemapUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("net.minecraft.entity.EntityTracker".equals(transformedName)) {
            ClassNode cn = new ClassNode();
            new ClassReader(basicClass).accept((ClassVisitor)cn, 0);
            for (MethodNode mn : cn.methods) {
                if (!RemapUtils.checkMethodName(cn.name, mn.name, mn.desc, "<init>") || !RemapUtils.checkMethodDesc(mn.desc, "(Lnet/minecraft/world/WorldServer;)V")) continue;
                for (AbstractInsnNode ain : mn.instructions.toArray()) {
                    if (ain.getOpcode() != 181) continue;
                    FieldInsnNode min = (FieldInsnNode)ain;
                    if (!RemapUtils.checkClassName(min.owner, "net/minecraft/entity/EntityTracker") || !RemapUtils.checkFieldName(min.owner, min.name, min.desc, "field_72793_b") || !RemapUtils.checkFieldDesc(min.desc, "Ljava/util/Set;")) continue;
                    mn.instructions.insertBefore(ain, (AbstractInsnNode)new InsnNode(87));
                    mn.instructions.insertBefore(ain, (AbstractInsnNode)new MethodInsnNode(184, "java/util/concurrent/ConcurrentHashMap", "newKeySet", "()Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", false));
                }
            }
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            basicClass = cw.toByteArray();
        }
        return basicClass;
    }
}

